def get_all_wrappers(env):
    """Returns all the wrappers of an environment up until it hits the Game class (not including the Game class).

    Args:
        env(MultiAgentAtariEnvWrapper): the environment for which the wrappers needs to be retrieved
    """
    from ai_collusion.gym_envs.envs.bertrand_competition import BertrandCompetitionDiscreteEnv
    from stable_baselines3.common.vec_env.dummy_vec_env import DummyVecEnv

    currentenv = env
    list_of_wrappers = [currentenv]
    while not type(currentenv) == BertrandCompetitionDiscreteEnv:
        if type(currentenv) == DummyVecEnv:
            currentenv = currentenv.envs[0]
        else:
            currentenv = currentenv.env
        list_of_wrappers.append(currentenv)

    if type(currentenv) == BertrandCompetitionDiscreteEnv:
        list_of_wrappers.append(currentenv)

    return list_of_wrappers